VERSION ("MODEM TEST 1.1")

'********************************************************************************
'
'Sample Program for MODEM Connection
'
'
'********************************************************************************

	OFF ALL
	OFF READER (1)
	ALPHA_LOCK (2)
	DISABLE READER(1)

	GOSUB ResetPage
	GOSUB MainFormInput
	END


ResetPage:
	StrPhoneNumber$ = ""		'Phone Number

	IntMaxPhoneLen% = 12		'v1.1+, Pomelo, Maximum phone length, 2004/11/02
	IntCurPhoneLen% = 0		'v1.1+, Pomelo, Current phone length, 2004/11/02
	IntBaudrate%    = 3		'v1.1+, Pomelo, default baudrate: 57600bps, 2004/10/29
	IntErrorCode%	= 0		'v1.1+, Pomelo, error code, 2004/10/29

	StrCRLF$        = CHR$ (13)
	GOSUB MainFormPage
	RETURN


MainFormPage:
	CLS
	CURSOR (0)
	SET_VIDEO_MODE (0)

	SELECT_FONT (2)
	LOCATE 2,1
	PRINT "Phone Number"
	LOCATE 4,1
	PRINT  StrPhoneNumber$

	' v1.1+, Pomelo, Set baudrate, 2004/10/29
	LOCATE 6,1
	PRINT "Speed"
	LOCATE 6,7
	IF IntBaudrate% = 1 THEN
		PRINT "115200"
	ELSE IF IntBaudrate% = 3 THEN
		PRINT "57600"		
	ELSE IF IntBaudrate% = 4 THEN
		PRINT "38400"
	ELSE IF IntBaudrate% = 5 THEN
		PRINT "19200"
	ELSE
		PRINT "9600"
	END IF

	SELECT_FONT(1)
	LOCATE 7,1
	PRINT "[Enter]: Start"
	LOCATE 8,1
	PRINT "[ ESC ]: Reset"

	SELECT_FONT (2)
	IF IntCurPhoneLen% >= IntMaxPhoneLen% THEN
		LOCATE 4, IntCurPhoneLen%
	ELSE
		LOCATE 4, IntCurPhoneLen%+1
	END IF

	CURSOR (1)
	RETURN


MainFormInput:
	IntFlagMainInput% = 1
	IntCurPhoneLen%   = LEN (StrPhoneNumber$)

	WHILE IntFlagMainInput% > 0
		IntErrorCode% = 0
		StrKeyData$   = ""
		StrKeyData$   = INKEY$

		IF StrKeyData$ <> "" THEN
			IntKeyData% = ASC (StrKeyData$)
			IF IntKeyData% = 13 THEN		'Enter
				IF IntCurPhoneLen% > 0 THEN
					GOSUB STARTTRANSMISSION
				ELSE
					IntErrorCode% = 1	'Error phone format
					GOSUB ERRORPAGE
				END IF
			ELSE IF IntKeyData% = 8 THEN		'Backspace
				IF IntCurPhoneLen% > 0 THEN
					IntCurPhoneLen% = IntCurPhoneLen% - 1
					StrPhoneNumber$ = LEFT$ (StrPhoneNumber$, IntCurPhoneLen%)
				END IF
			ELSE IF IntKeyData% = 27 THEN		'Esc
				GOSUB ResetPage
			'v1.1+, Pomelo, Use up-key and down-key to select baudrate
			ELSE IF IntKeyData% = 140 THEN		'Up-key
				IF IntBaudrate% > 1 THEN
					IF IntBaudrate% = 3 THEN
						IntBaudrate% = 1
					ELSE
						IntBaudrate% = IntBaudrate% - 1
					END IF
				END IF
			ELSE IF IntKeyData% = 141 THEN		' Down-key
				IF IntBaudrate% < 6 THEN
					IF IntBaudrate% = 1 THEN
						IntBaudrate% = 3
					ELSE
						IntBaudrate% = IntBaudrate% + 1
					END IF
				END IF
			'0 ~ 9  and String length less than 20
			ELSE IF IntKeyData% >= 48 AND IntKeyData% <= 57 THEN
				IF IntCurPhoneLen% = IntMaxPhoneLen% THEN
					IntCurPhoneLen% = IntCurPhoneLen% -1
					StrPhoneNumber$ = LEFT$ (StrPhoneNumber$, IntCurPhoneLen%)
				END IF
				StrPhoneNumber$ = StrPhoneNumber$ + StrKeyData$
				IntCurPhoneLen% = IntCurPhoneLen% + 1
			END IF

		CLR_KBD
		GOSUB MainFormPage
		END IF
		WAIT (25)
	WEND
	RETURN


ConnectingPage:
	CLS
	SELECT_FONT (2)
	CURSOR (0)
	LOCATE 2,1
	PRINT "Connecting.."
	LOCATE 6,1
	PRINT "Press ESC to"
	LOCATE 8,1
	PRINT "cancel."
	RETURN


STARTTRANSMISSION:
	' communication settings
	SET_COM_TYPE (1, 3)			'set com type
	SET_COM (1, IntBaudrate%, 1, 2, 1)	'com port, baudrate, no parity, 8, no handshake
	SET_RTS (1, 1)				'enable RTS
	OPEN_COM (1)				'open com

	'Clear com port
	StrCommand$ = CHR$ (13)
	WRITE_COM (1, StrCommand$)
	WAIT (20)
	StrCommand$ = READ_COM$ (1)

	GOSUB ConnectingPage
	IntRetry%     = 0
	IntLimit%     = 10
	IntProcess%   = 1
	IntErrorCode% = 0

	WHILE IntRetry% <> IntLimit%
		GOSUB WRITE_TO_COM
		GOSUB READ_FROM_COM

		IF IntErrorCode% = 4 THEN
			GOSUB DISCONNECTION
			GOSUB ErrorPage
			RETURN
		END IF

		IF IntResult% = 1 THEN
			IF IntProcess% < 5 THEN
				IntProcess% = IntProcess% + 1
			ELSE
				GOSUB ConnectSuccessfullyPage
'				WAIT (300)
				GOSUB TRANSMIT_DATA
				GOSUB DISCONNECTION
				RETURN
			END IF
		ELSE IF IntResult% = 0 THEN
			IF IntProcess% < 5 THEN
				IntProcess% = 1
				IntRetry%   = IntRetry% + 1
			ELSE
				IntRetry% = IntLimit%
			END IF
		END IF
	WEND

	IF IntProcess% < 5 THEN
		IntErrorCode% = 2
	ELSE
		IntErrorCode% = 3
		GOSUB DISCONNECTION
	END IF

	GOSUB ErrorPage
	RETURN


WRITE_TO_COM:
	COM_DELIMITER (1, 13)

	StrCommand$ = ""
	IF IntProcess% = 1 THEN
		StrCommand$ = "ATE0"
	ELSE IF IntProcess% = 2 THEN
		StrCommand$ = "ATH0"
	ELSE IF IntProcess% = 3 THEN
		StrCommand$ = "ATE0L3S0=3"
	ELSE IF IntProcess% = 4 THEN
		StrCommand$ = "AT&D0&K0"
	ELSE
		StrCommand$ = "ATX4DT" + StrPhoneNumber$
	END IF

	WRITE_COM (1, StrCommand$)
	WAIT (30)
	RETURN


READ_FROM_COM:
	COM_DELIMITER (1, 10)
	StrTemp$     = ""
	IntRcvLen%   = 0
	IntTimeOut%   = 0
	IF IntProcess% < 5 THEN
		IntTimeTotal% = 5 
	ELSE
		IntTimeTotal% = 60
	END IF

	WHILE IntRcvLen% = 0 AND IntTimeOut% < IntTimeTotal%
		StrReceived$ = ""
		IntRcvTemp%  = LEN (StrTemp$)
		IF IntRcvTemp% > 0 THEN
			StrReceived$ = StrTemp$ + StrReceived$
		END IF

		StrKeyData$ = ""
		IntKeyData% = 0
		StrKeyData$ = INKEY$
		IF StrKeyData$ <> "" THEN
			IntKeyData% = ASC (StrKeyData$)
			IF IntKeyData% = 27 THEN
				IntErrorCode% = 4
				RETURN
			END IF
		END IF

		StrReceived$ = READ_COM$ (1)
		IntRcvLen%   = LEN (StrReceived$)

		IF IntRcvLen% > 0 THEN
			StrTemp$ = RIGHT (StrReceived$, 1)
			IF StrTemp$ <> StrCRLF$ THEN
				StrTemp$   = StrReceived$
				IntRcvLen% = 0
			ELSE IF IntRcvLen% <= 1 THEN
				IntRcvLen% = 0
			ELSE
				StrTemp$ = READ_COM$ (1)
				StrTemp$ = ""
			END IF
		ELSE
			IntTimeOut% = IntTimeOut% + 1
		END IF

		IF IntRcvLen% = 0 THEN		
			IF IntProcess% < 5 THEN
				WAIT (100)
			ELSE
				WAIT (200)
			END IF
		END IF
	WEND

	IntResult%   = 0
	IntSerchStr% = 0
	IF IntProcess% < 5 THEN
		IntSerchStr% = INSTR (StrReceived$,  "OK")
		IF IntSerchStr% > 0 THEN
			IntResult% = 1
		END IF
	ELSE
		IntSerchStr% = INSTR (StrReceived$,  "CONNECT")
		IF IntSerchStr% > 0 THEN
			IntResult% = 1
		ELSE
			IntErrorCode% = 3
		END IF
	END IF
	RETURN


ConnectSuccessfullyPage:
	CLS
	SELECT_FONT (2)
	CURSOR (0)
	LOCATE 2,1
	PRINT "Connecting"
	LOCATE 4,1
	PRINT "Successfully"
	SELECT_FONT(1)
	LOCATE 7,2
	PRINT "Press ESC to"
	LOCATE 8,2
	PRINT "Disconnect."

	BEEP(3000,10)
	RETURN


SendingDataPage:
	CLS
	SELECT_FONT (2)
	CURSOR (0)
	LOCATE 2,1
	PRINT "Sending Data"
	SELECT_FONT(1)
	LOCATE 7,2
	PRINT "Press ESC to"
	LOCATE 8,2
	PRINT "Disconnect."
	RETURN


TRANSMIT_DATA:
	GOSUB SendingDataPage

	COM_DELIMITER (1, 13)
	IntDisconnect% = 0
	I% = 1

	WHILE IntDisconnect% = 0
		StrKeyData$ = ""
		IntKeyData% = 0
		StrKeyData$ = INKEY$
		IF StrKeyData$ <> "" THEN
			IntKeyData% = ASC (StrKeyData$)
			IF IntKeyData% = 27 THEN
				IntErrorCode% = 4
				RETURN
			END IF
		END IF

		StrCommand$ = "Data Record:" + STR$ (I%)
		WRITE_COM (1, StrCommand$)
		IF I% = 9999 THEN
			I% = 1
		ELSE
			I% = I% + 1
		END IF
		WAIT (20)
	WEND
	RETURN


Disconnection:
	COM_DELIMITER (1, 13)
	WRITE_COM (1, "ATH0")
	WAIT (40)
	CLOSE_COM(1)
	RETURN


ErrorPage:
	CLS
	CURSOR (0)

	IF IntErrorCode% = 1 THEN
		Msg1$ = "Invaild"
		Msg2$ = "Phone Number"
	ELSE IF IntErrorCode% = 2 THEN
		Msg1$ = "Config Modem"
		Msg2$ = "Error!!"
	ELSE IF IntErrorCode% = 3 THEN
		Msg1$ = "Transmission"
		Msg2$ = "Error!!"
	ELSE IF IntErrorCode% = 4 THEN
		Msg1$ = "User cancel!"
		Msg2$ = ""
	END IF

	SELECT_FONT (2)
	LOCATE 2,1
	PRINT Msg1$
	LOCATE 4,1
	PRINT Msg2$
	SELECT_FONT (1)
	LOCATE 7,2
	PRINT "Press Any key"
	LOCATE 8,2
	PRINT "to exit!!"
	SET_VIDEO_MODE (0)

	IntFlagErrorInput% = 1
	WHILE IntFlagErrorInput% > 0
		StrKeyData$ = ""
		StrKeyData$ = INKEY$
		IF StrKeyData$ <> "" THEN
			IntFlagErrorInput% = 0
		END IF
	WEND
	RETURN